XIncludeFile "init.pbi"

Procedure Init()
  UsePNGImageDecoder()
  
  If OpenWindow(#Window, 0, 0, #WINDOW_WIDTH, #WINDOW_HEIGHT, "Map editor", #PB_Window_SystemMenu | #PB_Window_MinimizeGadget | #PB_Window_MaximizeGadget | #PB_Window_SizeGadget | #PB_Window_ScreenCentered | #PB_Window_TitleBar)=0
    MessageRequester("OpenWindow() error", "Can't open editor.")
    End
  EndIf
  
  WindowBounds(#Window, #WINDOW_WIDTH, #WINDOW_HEIGHT, #PB_Ignore, #PB_Ignore) 
  
  If CreateImageMenu(#Menu, WindowID(#Window), #PB_Menu_ModernLook)
    MenuTitle("File")
    MenuItem(#New,"New")
    MenuItem(#Open,"Open...")
    MenuItem(#Save,"Save")
    MenuItem(#Save_as,"Save as...")
    MenuItem(#Export,"Export...")
    MenuItem(#Close,"Close")
    MenuBar()
    MenuItem(#Quit,"Quit")
    MenuTitle("Tools")
    MenuItem(#Grid, "Grid")
    MenuItem(#Tiles_editor,"Tiles editor")
    MenuItem(#Masks_editor,"Masks editor")
    MenuItem(#Screenshot,"Screenshot")
    MenuTitle("Help")
    MenuItem(#About,"About...")
    DisableMenuItem(#Menu, #Save, 1)
    DisableMenuItem(#Menu, #Save_as, 1)
    DisableMenuItem(#Menu, #Export, 1)
    DisableMenuItem(#Menu, #Close, 1)
    DisableMenuItem(#Menu, #Grid, 1)
    DisableMenuItem(#Menu, #Screenshot, 1)
  EndIf
  
  If CreateToolBar(#ToolBar, WindowID(#Window))
    ToolBarImageButton(#New, ImageID(CatchImage(#PB_Any, ?New_icon)))
    ToolBarImageButton(#Open, ImageID(CatchImage(#PB_Any, ?Open_icon)))
    ToolBarImageButton(#Save, ImageID(CatchImage(#PB_Any, ?Save_icon)))
    ToolBarSeparator()
    ToolBarImageButton(#Pen, ImageID(CatchImage(#PB_Any, ?Pen_icon)), #PB_ToolBar_Toggle)
    ToolBarImageButton(#Square, ImageID(CatchImage(#PB_Any, ?Square_icon)), #PB_ToolBar_Toggle)
    ToolBarImageButton(#Fill, ImageID(CatchImage(#PB_Any, ?Fill_icon)), #PB_ToolBar_Toggle)
    ToolBarSeparator()
    ToolBarImageButton(#Zoom1, ImageID(CatchImage(#PB_Any, ?Zoom1_icon)), #PB_ToolBar_Toggle)
    ToolBarImageButton(#Zoom2, ImageID(CatchImage(#PB_Any, ?Zoom2_icon)), #PB_ToolBar_Toggle)
    ToolBarSeparator()
    ToolBarImageButton(#Export, ImageID(CatchImage(#PB_Any, ?Triangle_icon)))
    ToolBarToolTip(#ToolBar, #New, "New")
    ToolBarToolTip(#ToolBar, #Open, "Open...")
    ToolBarToolTip(#ToolBar, #Save, "Save")
    ToolBarToolTip(#ToolBar, #Pen, "Pen")
    ToolBarToolTip(#ToolBar, #Square, "Square")
    ToolBarToolTip(#ToolBar, #Fill, "Fill")
    ToolBarToolTip(#ToolBar, #Zoom1, "Zoom *1")
    ToolBarToolTip(#ToolBar, #Zoom2, "Zoom *2")
    ToolBarToolTip(#ToolBar, #Export, "Export to .inc")
    DisableToolBarButton(#ToolBar, #Save, 1)
    DisableToolBarButton(#ToolBar, #Pen, 1)
    DisableToolBarButton(#ToolBar, #Square, 1)
    DisableToolBarButton(#ToolBar, #Fill, 1)
    DisableToolBarButton(#ToolBar, #Zoom1, 1)
    DisableToolBarButton(#ToolBar, #Zoom2, 1)
    DisableToolBarButton(#ToolBar, #Export, 1)
  EndIf
  
  If CreateStatusBar(#StatusBar, WindowID(#Window))
    AddStatusBarField(#PB_Ignore)
  EndIf
  
  UseSQLiteDatabase()
  UsePNGImageDecoder()
  UsePNGImageEncoder()
  
  If OpenDatabase(#Database, "database.sqlite", "", "") = 0
    If CreateFile(0, "database.sqlite")
      CloseFile(0)
      If OpenDatabase(#Database, "database.sqlite", "", "")
        DatabaseUpdate(#Database, "CREATE TABLE brush ( tile BIGINT, animation BOOLEAN, passable BOOLEAN, height INT, masked BOOLEAN , mask BIGINT , collision TEXT, interaction TEXT );")
        DatabaseUpdate(#Database, "CREATE TABLE mask ( id BIGINT PRIMARY KEY, sprite TEXT );")
        DatabaseUpdate(#Database, "CREATE TABLE tile ( id BIGINT PRIMARY KEY, sprite TEXT );")
      Else
        MessageRequester("OpenDatabase() error", "Can't open or create database.")
        End
      EndIf
    Else
      MessageRequester("CreateFile() error", "Can't create database.")
      End
    EndIf
  EndIf
EndProcedure

Procedure InitWorkArea()
  CreateImage(#MapImage, map_\w*#TILE_WIDTH, map_\h*#TILE_HEIGHT)
  
  DisableMenuItem(#Menu, #Save_as, 0)
  DisableMenuItem(#Menu, #Export, 0)
  DisableMenuItem(#Menu, #Close, 0)
  DisableMenuItem(#Menu, #Grid, 0)
  DisableMenuItem(#Menu, #Screenshot, 0)
  DisableToolBarButton(#ToolBar, #Pen, 0)
  DisableToolBarButton(#ToolBar, #Square, 0)
  DisableToolBarButton(#ToolBar, #Fill, 0)
  DisableToolBarButton(#ToolBar, #Zoom1, 0)
  DisableToolBarButton(#ToolBar, #Zoom2, 0)
  DisableToolBarButton(#ToolBar, #Export, 0)
  SetToolBarButtonState(#ToolBar, #Pen, 1)
  SetToolBarButtonState(#ToolBar, #Zoom1, 1)
  tool = 1
  zoom = 1
  grid = 0
  
  UseGadgetList(WindowID(#Window))
  
  Protected i.l = 0
  If DatabaseQuery(#Database, "SELECT * FROM tile ORDER BY id;")
    While NextDatabaseRow(#Database)
      tiles(Str(i)) = GetDatabaseString(#Database, 1)
      i+1
    Wend
    FinishDatabaseQuery(#Database)
  Else
    MessageRequester("DatabaseUpdate() error", DatabaseError())
    End
  EndIf
  
  i = 0
  If DatabaseQuery(#Database, "SELECT * FROM brush ORDER BY id;")
    While NextDatabaseRow(#Database)
      brushes(Str(i))\tile = GetDatabaseLong(#Database, 1)
      brushes(Str(i))\animation = GetDatabaseLong(#Database, 2)
      brushes(Str(i))\offset = GetDatabaseLong(#Database, 3)
      brushes(Str(i))\passable = GetDatabaseLong(#Database, 4)
      brushes(Str(i))\height = GetDatabaseLong(#Database, 5)
      brushes(Str(i))\masked = GetDatabaseLong(#Database, 6)
      brushes(Str(i))\mask = GetDatabaseLong(#Database, 7)
      brushes(Str(i))\collision = GetDatabaseString(#Database, 8)
      brushes(Str(i))\interaction = GetDatabaseString(#Database, 9)
      i+1
    Wend
    FinishDatabaseQuery(#Database)
  Else
    MessageRequester("DatabaseUpdate() error", DatabaseError())
    End
  EndIf
  
  ListIconGadget(#BrushesListIcon, #BrushesListIcon_x, #BrushesListIcon_y, #BrushesListIcon_w, #BrushesListIcon_h, "Brushes", #BrushesColumn1_w, #PB_ListIcon_FullRowSelect | #PB_ListIcon_AlwaysShowSelection)
  AddGadgetColumn(#BrushesListIcon, 2, "ID", #BrushesColumn2_w)
  AddGadgetColumn(#BrushesListIcon, 3, "tile", #BrushesColumn3_w)
  AddGadgetColumn(#BrushesListIcon, 4, "animation", #BrushesColumn4_w)
  AddGadgetColumn(#BrushesListIcon, 5, "offset", #BrushesColumn5_w)
  AddGadgetColumn(#BrushesListIcon, 6, "passable", #BrushesColumn6_w)
  AddGadgetColumn(#BrushesListIcon, 7, "height", #BrushesColumn7_w)
  AddGadgetColumn(#BrushesListIcon, 8, "masked", #BrushesColumn8_w)
  AddGadgetColumn(#BrushesListIcon, 9, "mask", #BrushesColumn9_w)
  AddGadgetColumn(#BrushesListIcon, 10, "collision", #BrushesColumn10_w)
  AddGadgetColumn(#BrushesListIcon, 11, "interaction", #BrushesColumn11_w)
  RefreshBrushes()
  
  ButtonGadget(#UpButton2, #UpButton2_x, #UpButton2_y, #UpButton2_w, #UpButton2_h, "Up")
  DisableGadget(#UpButton2, 1)
  ButtonGadget(#DownButton2, #DownButton2_x, #DownButton2_y, #DownButton2_w, #DownButton2_h, "Down")
  DisableGadget(#DownButton2, 1)
  ButtonGadget(#AddButton2, #AddButton2_x, #AddButton2_y, #AddButton2_w, #AddButton2_h, "Add")
  ButtonGadget(#RemoveButton2, #RemoveButton2_x, #RemoveButton2_y, #RemoveButton2_w, #RemoveButton2_h, "Remove")
  DisableGadget(#RemoveButton2, 1)
  ButtonGadget(#EditButton, #EditButton_x, #EditButton_y, #EditButton_w, #EditButton_h, "Edit")
  DisableGadget(#EditButton, 1)
  
  ScrollAreaGadget(#MapScrollArea, #MapScrollArea_x, #MapScrollArea_y, WindowWidth(#Window)-#MapScrollArea_x-1, WindowHeight(#Window)-#MapScrollArea_y-44, ImageWidth(#MapImage), ImageHeight(#MapImage), 1, #PB_ScrollArea_Single|#PB_ScrollArea_Center)
  CanvasGadget(#MapGadget, 0, 0, ImageWidth(#MapImage), ImageHeight(#MapImage))
  CloseGadgetList()
  
  ProcedureReturn 1
EndProcedure

Procedure RefreshBrushes()
  ForEach brushes()
    LoadImage(Val(MapKey(brushes())), "tiles\"+tiles(Str(brushes()\tile)))
    AddGadgetItem(#BrushesListIcon, -1, Chr(10)+MapKey(brushes())+Chr(10)+tiles(Str(brushes()\tile))+Chr(10)+Str(brushes()\animation)+Chr(10)+Str(brushes()\offset)+Chr(10)+Str(brushes()\passable)+Chr(10)+Str(brushes()\height)+Chr(10)+Str(brushes()\masked)+Chr(10)+Str(brushes()\mask)+Chr(10)+brushes()\collision+Chr(10)+brushes()\interaction, ImageID(Val(MapKey(brushes()))))
  Next
EndProcedure

DataSection
  New_icon:
  IncludeBinary "icons/new.ico"
  Open_icon:
  IncludeBinary "icons/open.ico"
  Save_icon:
  IncludeBinary "icons/save.ico"
  Pen_icon:
  IncludeBinary "icons/pen.ico"
  Square_icon:
  IncludeBinary "icons/square.ico"
  Fill_icon:
  IncludeBinary "icons/fill.ico"
  Zoom1_icon:
  IncludeBinary "icons/zoom1.ico"
  Zoom2_icon:
  IncludeBinary "icons/zoom2.ico"
  Triangle_icon:
  IncludeBinary "icons/triangle.ico"
EndDataSection
; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 74
; FirstLine = 51
; Folding = -
; UseMainFile = main.pb
; CurrentDirectory = ..\